### 1. Overview of CPPr (Control Plane Protection with Policing)

- **CPPr** extends CoPP (Control Plane Policing) by:
    - Automatically classifying all CPU-bound traffic into three separate queues (subinterfaces) under the control plane interface.
    - Each subinterface handles a specific traffic type and has its own traffic policy, simplifying configuration.

---

### 2. CPPr Control Plane Subinterfaces

- **Three Subinterfaces Automatically Created:**
    - **Control-plane host subinterface**
        - Handles all control plane IP traffic destined directly to the router (physical/loopback interfaces).
        - Example traffic: tunnel termination, management (SSH, SNMP), routing protocols (IBGP, EIGRP).
        - Most CPPr policies operate here; critical for protecting routing and management functions.
        - Supports features like CoPP, port filtering, per-protocol queue thresholding.
    - **Control-plane Cisco Express Forwarding-exception subinterface**
        - Handles traffic redirected for process switching or enqueued by the interface driver.
        - Example traffic: ARP, EBGP, OSPF, LDP, Layer 2 keepalives, non-IP host traffic.
        - Allows aggregate policing of this control plane traffic type.
    - **Control-plane transit subinterface**
        - Handles software-switched control plane IP traffic not destined for the router (e.g., traffic traversing through the router).
        - Example: router-handled tunnels.
        - Allows aggregate policing for received traffic at this subinterface.
    - **Note:** Transit and CEF-exception subinterfaces process all slow-path data plane forwarding traffic together.

---

### 3. Steps to Configure CPPr

- **1. Create Traffic Classes**
    - Define valid control plane traffic using access lists and class maps.
- **2. Create a Traffic Policy**
    - Specify actions for each class (permit, deny, rate-limit).
    - Helps conserve resources and acts as a device firewall.
- **3. Apply Policy to Subinterface**
    - Attach the created policy to the appropriate CPPr subinterface (e.g., host).

---

### 4. Example Configuration Scenario

- **Scenario Details:**
    - Device uses EIGRP with three peers (10.0.0.0/8 network), max 200 EIGRP packets/sec.
    - All other control plane traffic limited to 50 packets/sec.
- **Configuration Steps:**
    - **Access-list**: Defines EIGRP traffic.
        - `ip access-list extended CPPR-EIGRP permit eigrp 10.0.0.0 0.255.255.255 any`
    - **Class-map**: Matches EIGRP traffic.
        - `class-map CPPR-EIGRP-CLASS match access-group name CPPR-EIGRP`
    - **Policy-map**: Specifies rate limits.
        - EIGRP: 200 packets/sec; other: 50 packets/sec.
        - `policy-map CPPR-POLICY`
    - **Apply Policy**: Attaches to host subinterface.
        - `control-plane host service-policy input CPPR-POLICY`

---

### 5. Verification of CPPr Configuration

- **Command:** `show policy-map control-plane all`
    - Displays the configuration and operational statistics of CPPr policies.
- **Sample Output Information:**
    - Packets matched per class
    - Policy actions (transmit/drop)
    - Offered and drop rates
    - Confirmation of correct policing and protection

---

### 6. Key Points

- CPPr enhances control plane protection by separating CPU-bound traffic into manageable, policy-controlled subinterfaces.
- Enables granular policing, improving security for critical routing and management functions.
- Proper configuration and verification are essential for effective protection.